<?php 
include_once "config.php";

$page = "county";

// Parse state and county
$request_uri = $_SERVER['REQUEST_URI'];
$parts = explode('/', trim($request_uri, '/'));

$state = isset($parts[0]) ? strtoupper($parts[0]) : '';
$county = isset($parts[1]) ? strtolower(pathinfo($parts[1], PATHINFO_FILENAME)) : '';

// Validate state
$States = array("AK", "AL", "AR", "AZ", "CA", "CO", "CT", "DC", "DE", "FL", "GA", "HI", "IA", "ID", "IL", "IN", "KS", "KY", "LA", "MA", "MD", "ME", "MI", "MN", "MO", "MS", "MT", "NC", "ND", "NE", "NH", "NJ", "NM", "NV", "NY", "OH", "OK", "OR", "PA", "RI", "SC", "SD", "TN", "TX", "UT", "VA", "VT", "WA", "WI", "WV", "WY");

if (!in_array($state, $States)) {
    echo "Invalid state.";
    exit;
}

// Display the county page
?>
<!DOCTYPE html>
<html>
<head>
    <title><?php echo htmlspecialchars($state); ?> County</title>
</head>
<body>
    <h1>Welcome to <?php echo htmlspecialchars($county); ?> County</h1>
    <p>State: <?php echo htmlspecialchars($state); ?></p>
</body>
</html>
